/*
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1, 1.2_beta
 */

package samplermi;

import java.rmi.*;
import java.rmi.server.*;

/**
 * Remote object to receive calls forwarded from the ServletHandler.
 */
public class SampleRMIServer extends java.rmi.server.UnicastRemoteObject 
    implements SampleRMI {

    public SampleRMIServer() throws RemoteException {};

    public String justPass(String passed) throws RemoteException {
	return "String passed to remote server: " + passed;
    }

    /**
     * You should not need to run this server from the command line.
     * The ServletHandler class creates its own instance of the
     * rmiregistry and (optionally) an instance of this class as well.
     * This main method will not be executed from the ServletHandler.  
     */
    public static void main(String args[]) {
	try {
	    System.setSecurityManager(new RMISecurityManager());

	    // create a registry if one is not running already.
	    try {
		java.rmi.registry.LocateRegistry.createRegistry(1099);
	    } catch (java.rmi.server.ExportException ee) {
		// registry already exists, we'll just use it.
	    } catch (RemoteException re) {
		System.err.println(re.getMessage());
		re.printStackTrace();
	    }
	    
	    Naming.rebind("/SampleRMI", new SampleRMIServer());
	    
	}catch(Exception e){
	    System.out.println("Error: "+e.getMessage());
	    e.printStackTrace();
	}
    }
}
