/*
 * @(#)hprof_trace.h	1.2 98/08/18
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_TRACE_H
#define _HPROF_TRACE_H

#define CPU_SAMPLES_RECORD_NAME ("CPU SAMPLES")
#define CPU_TIMES_RECORD_NAME ("CPU TIME (ms)")
#define MONITOR_SAMPLES_RECORD_NAME ("MONITOR SAMPLES")
#define MONITOR_TIMES_RECORD_NAME ("MONITOR TIME (ms)")

/* Frames */
typedef struct hprof_frame_t {
    int marked;                        /* been written to output? */
    signed int lineno;                 /* line number */
    struct hprof_method_t *method;     /* method being executed */
} hprof_frame_t;

/* Stack traces */
typedef struct hprof_trace_t {
    unsigned int marked;               /* been written to output? */
    unsigned int serial_num;           /* serial number, starts from 1 */
    unsigned int num_hits;             /* number of hits */
    jlong cost;                        /* # of times sampled or time in ms */
    unsigned int thread_serial_num;    /* thread serial number */
    unsigned int n_frames;             /* number of frames */
    struct hprof_frame_t *frames[1];   /* frames */
} hprof_trace_t;

/* Auxilary data structure used for collecting trace info. */
typedef struct hprof_trace_iterate_t {
    hprof_trace_t **traces;               
    int index;
    int total_count;
} hprof_trace_iterate_t;

void hprof_trace_table_init(void);
hprof_trace_t * hprof_alloc_tmp_trace(int n_frames, JNIEnv *env_id);
hprof_trace_t * hprof_intern_tmp_trace(hprof_trace_t *trace_tmp);
hprof_trace_t * hprof_intern_jvmpi_trace(JVMPI_CallFrame *frames, int n_frames,
					 JNIEnv *env_id);
hprof_trace_t *hprof_get_trace(JNIEnv *env_id, int depth);
void hprof_output_unmarked_traces(void);
void hprof_output_trace_cost(float cutoff, char *record_name);
void hprof_output_trace_cost_in_prof_format(void);
void hprof_clear_trace_cost(void);

void hprof_frame_table_init(void);
hprof_frame_t * hprof_intern_jvmpi_frame(jmethodID method_id, int lineno);

#endif /* _HPROF_TRACE_H */
