/*
 * @(#)hprof_thread.h	1.3 98/08/24
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_THREAD_H
#define _HPROF_THREAD_H

#include "hprof_monitor.h"

/* Threads */
typedef struct hprof_thread_t {
    JNIEnv *env_id;                    /* env of thread */
    struct hprof_objmap_t *thread_id;  /* ptr to jvm<--->hprof object map */
    unsigned int serial_num;           /* unique serial number */
} hprof_thread_t;

/* recording an active thread */
typedef struct live_thread_t {
    struct live_thread_t *next;          /* next thread */
    struct live_thread_t *nextSuspended; /* next suspended thread */
    struct hprof_objmap_t *tid;          /* thread object ID */
    JNIEnv *env;                         /* JNIEnv */
    int cpu_sampled:1;                   /* thread CPU profile on? */
} live_thread_t;

/* list of active threads */
extern live_thread_t *live_thread_list;
extern int num_live_threads;

void hprof_thread_table_init(void);
hprof_thread_t * hprof_intern_thread(JNIEnv *env_id);
void hprof_remove_thread(JNIEnv *env_id);
hprof_thread_t *hprof_lookup_thread(JNIEnv *env_id);
void hprof_thread_start_event(JNIEnv *env_id,
			      char *t_name,
			      char *g_name,
			      char *p_name,
			      jobjectID thread_id,
			      int requested);
void hprof_thread_end_event(JNIEnv *env_id);
hprof_thread_t * hprof_fetch_thread_info(JNIEnv *env);
void hprof_print_thread_info(JNIEnv *env, int leading_comma);

/* method time */
typedef struct hprof_method_time_t {
    jmethodID method_id;               /* method id */
    jlong start_time;                  /* method start time */
    jlong time_in_callees;             /* time in callees */
    jlong time_in_gc;                  /* time in gc */
} hprof_method_time_t;

/* thread local info for timing methods */
typedef struct hprof_frames_cost_t {
    struct hprof_frames_cost_t *next;
    int num_frames;                    /* # of frames in call stack */
    int frames_index;                  /* start index into frames_array */
    jlong self_time;                   /* time spent only in the method */
    jlong total_time;                  /* total - including time in callees */
    unsigned int num_hits;             /* count */
} hprof_frames_cost_t;

typedef struct hprof_thread_local_t {
    struct hprof_method_time_t *stack_top;    /* stack top */
    int stack_limit;                          /* stack limit */
    struct hprof_method_time_t *stack;        /* for tracking mthd entry/exit */ 
    JVMPI_RawMonitor table_lock;              /* table lock */
    jmethodID *frames_array;                  /* frames seen by this thread */
    int cur_frame_index;                      /* next free frame */
    int frames_array_limit;                   /* frames array limit */
    hprof_frames_cost_t **table;              /* hashtable for frames' cost */
    hprof_contended_monitor_t *mon;           /* last contended monitor info */
    jlong gc_start_time;                      /* time GC started */
} hprof_thread_local_t;

void hprof_bill_all_thread_local_tables(void);
void hprof_bill_frames_cost_table(JNIEnv *env_id);

/* thread local limits */
#define HPROF_STACK_LIMIT 2048
#define HPROF_FRAMES_ARRAY_LIMIT 4000
#define HPROF_FRAMES_TABLE_SIZE 20011

#endif /* _HPROF_THREAD_H */
