/* @(#)hprof_hash.c	1.2 98/12/17
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include <string.h>

#include "hprof.h"

/* initialise a hashtable */
void 
hprof_hash_init(hprof_hash_t *table, 
		int size,
		unsigned int (*hash_f)(void *),
		unsigned int (*size_f)(void *),
		int (*compare_f)(void *, void *))
{
    table->n_entries = 0;
    table->size = size;
    table->entries = hprof_calloc(size * sizeof(hprof_bucket_t *));
    table->hash_f = hash_f;
    table->size_f = size_f;
    table->compare_f = compare_f;
}

/* iterate through the hash table */
void *
hprof_hash_iterate(hprof_hash_t *table,
		   void * (*f)(void *, void *), 
		   void *arg)
{
    int i;
    for (i = 0; i < table->size; i++) {
        hprof_bucket_t *bucket = table->entries[i];
	while (bucket) {
	    arg = f(bucket->content, arg);
	    bucket = bucket->next;
	}
    }
    return arg;
}

/* remove an entry from the hash table */
void
hprof_hash_remove(hprof_hash_t *table, 
		  int (*f)(void *, void *), 
		  void *arg)
{
    int i;
    for (i = 0; i < table->size; i++) {
        hprof_bucket_t **p = &(table->entries[i]);
	hprof_bucket_t *bucket;
	while ((bucket = *p)) {
	    if (f(bucket->content, arg)) {
	        *p = bucket->next;
		hprof_free(bucket->content);
		hprof_free(bucket);
		table->n_entries--;
	        continue;
	    }
	    p = &(bucket->next);
	}
    }    
}

/* remove all entries from the hash table */
void
hprof_hash_removeall(hprof_hash_t *table)
{
    int i;
    for (i = 0; i < table->size; i++) {
        hprof_bucket_t **p = &(table->entries[i]);
	hprof_bucket_t *bucket;
	while ((bucket = *p)) {
	    *p = bucket->next;
	    hprof_free(bucket->content);
	    hprof_free(bucket);
	    table->n_entries--;
	}
    }
}

/* lookup a hashtable, if present, a ptr to the contents is
   returned, else a NULL. */
void *
hprof_hash_lookup(hprof_hash_t *table, 
		  void *new)
{
    int index = table->hash_f(new) % table->size;
    hprof_bucket_t **p = &(table->entries[index]);
    
    while (*p) {
      if (table->compare_f(new, (*p)->content) == 0) {
	  return (*p)->content;
      }
      p = &((*p)->next);
    }
    return NULL;
}

/* put an entry into a hashtable
   CAUTION - this should be used only if 
   hprof_hash_lookup returns NULL */
void * 
hprof_hash_put(hprof_hash_t *table, 
	       void *new)
{
    int index = table->hash_f(new) % table->size;
    int bytes = table->size_f(new);
    hprof_bucket_t *new_bucket = hprof_calloc(sizeof(hprof_bucket_t));
    void *ptr = hprof_calloc(bytes);
    
    memcpy(ptr, new, bytes);
    new_bucket->next = table->entries[index];
    new_bucket->content = ptr;
    table->entries[index] = new_bucket;
    table->n_entries++;
    return ptr;
}

/* intern an entry into the hash table */
void * 
hprof_hash_intern(hprof_hash_t *table, void *new)
{
    
    void *ptr = hprof_hash_lookup(table, new);
    if (ptr == NULL) {
        ptr = hprof_hash_put(table, new);
    }
    return ptr;
}


