
import java.awt.*;
import Account;
import Transaction;
import TransactionCollection;
import java.util.Date;

public class TransactionPanel extends PicturePanel
{
 
   int offset = 0;
   Image logo;
   Image check;
   Image topimg;
   Main parent;
   Button button1,  button3, button4;	
   //Button button2;
   Button ok = new Button("OK");

   Button up = new Button("up");
   Button dn = new Button("dn");
   Button pdn = new Button("pdn");
   Button pup = new Button("pup");

   //Label labels[] = new Label[6];
   TextField date[] = new TextField[5];
   TextField num[] = new TextField[5]; 
   TextField rec[] = new TextField[5];
   TextField cat[] = new TextField[5];
   TextField amt[] = new TextField[5];
   TextField bal[] = new TextField[5];
   TextField cto = new TextField();
   TextField camt = new TextField();
   TextField cnum = new TextField();
   TextField cdate = new TextField();
   TextField cfor = new TextField();
   Checkbox cb[] = new Checkbox[6];
   CheckboxGroup cg = new CheckboxGroup();

   Account globalAccount = new Account();

   int index, ypos;

   void initAcct()
   {

      globalAccount.balance = 100;
      globalAccount.name = "George Checking";
      globalAccount.owner = "George";
      globalAccount.interestRate = .06;

      globalAccount.transactions.addTransaction(
             new Transaction(101, "one", -1, 1, new Date("1/1/96"), "uno"));
      globalAccount.transactions.addTransaction(
             new Transaction(102, "two", -2, 2, new Date("2/2/96"), "dos"));
      globalAccount.transactions.addTransaction(
             new Transaction(103, "three", -3, 3, new Date("3/3/96"), "tres"));
      globalAccount.transactions.addTransaction(
             new Transaction(104, "four", -4, 4, new Date("4/4/96"), "cuatro"));
      globalAccount.transactions.addTransaction(
             new Transaction(105, "five", -5, 5, new Date("5/5/96"), "cinco"));
      globalAccount.transactions.addTransaction(
             new Transaction(106, "six", -6, 6, new Date("6/6/96"), "sies"));

      globalAccount.reCalcBalance();
   }

   TransactionPanel(Image picture, Image picture2, Image tp, Account acct, Main pt )
   {

      super(picture);

      logo = picture;
      check = picture2;
      topimg = tp;
      globalAccount = acct;
      parent = pt;

     
      button1 = new Button("New");
      button3 = new Button("Delete");
      button4 = new Button("Return");

      //labels[0] = new Label("No.");
      //labels[1] = new Label("Date");
      //labels[2] = new Label("Receipent");
      //labels[3] = new Label("Category");
      //labels[4] = new Label("Amount");
      //labels[5] = new Label("Balance");

      cto = new TextField();
      camt = new TextField();
      cnum = new TextField();
      cdate = new TextField();
      cfor = new TextField();

      for(index = 0; index < 5; index++)
      {
         date[index] = new TextField();	
         num[index] = new TextField();
         rec[index] = new TextField();
         cat[index] = new TextField();
         amt[index] = new TextField();
         bal[index] = new TextField();

         top.add(date[index]);      
         top.add(num[index]);
         top.add(rec[index]);
         top.add(cat[index]);
         top.add(amt[index]);
         top.add(bal[index]);
         //top.add(labels[index]);

         date[index].setEditable(false);        
         num[index].setEditable(false);        
         rec[index].setEditable(false);        
         cat[index].setEditable(false);        
         amt[index].setEditable(false);        
         bal[index].setEditable(false);        
 
         cb[index] = new Checkbox("", cg, false);
         top.add(cb[index]);
   
      }
      cb[5] = new Checkbox("", cg, false);
      //top.add(labels[5]);

      bottom.add(cto);
      bottom.add(camt);
      bottom.add(cnum);  
      bottom.add(cdate);
      bottom.add(cfor);

      top.add(up);
      top.add(dn);
      top.add(pup);
      top.add(pdn);
 
      top.add(button1);
      top.add(button3);
      top.add(button4);
      bottom.add(ok);
      repaint();
      refresh();
      globalAccount.reCalcBalance();

   }

   void refresh()
   {
      Transaction temp;

      try

      for(index = 0; index < 5; index++)
      {
         temp = globalAccount.transactions.returnTransaction(index+offset); 
         rec[index].setText(temp.recipient);
         cat[index].setText(temp.category);
         amt[index].setText(new Double(0-temp.amount).toString());          
         date[index].setText(goodDate(temp.date));
         num[index].setText(new Double(temp.transactionID).toString());
         bal[index].setText(new Double(temp.balance).toString());
      }

      catch(java.lang.ArrayIndexOutOfBoundsException e)
      {
         index = globalAccount.transactions.tCollection.size() - offset;
         for(; index < 5; index++)
         {
            rec[index].setText("");
            cat[index].setText("");
            amt[index].setText("");
            date[index].setText("");
            num[index].setText("");
            bal[index].setText("");
         }
      }
  
      if(getSelectedCheckbox() != -1)
         loadCheck(globalAccount.transactions.returnTransaction
                             (getSelectedCheckbox()));   
 
   }

   public void paint(Graphics g)
   {
      Graphics p = bottom.getGraphics();
      Graphics q = top.getGraphics();
      g.drawImage(logo, 1, 1, this);
      p.drawImage(check, 1, 1, this); 
      q.drawImage(topimg, 1, 10, this);
      
      for(index = 0; index < 5; index++)
      {
         ypos = (index * 28) + 38;
         cb[index].reshape(1, ypos, 28, 28);
         num[index].reshape(27, ypos, 50, 28);
         date[index].reshape(77, ypos, 80, 28);
         rec[index].reshape(157, ypos, 95, 28);
         cat[index].reshape(252, ypos, 100, 28);
         amt[index].reshape(352, ypos, 60, 28);
         bal[index].reshape(412, ypos, 80, 28);
      } 

      /*labels[0].reshape(33, 10, 50, 28);
      labels[1].reshape(83, 10, 60, 28);
      labels[2].reshape(143, 10, 115, 28);
      labels[3].reshape(258, 10, 100, 28);
      labels[4].reshape(358, 10, 100, 28);
      labels[5].reshape(458, 10, 80, 28);
*/ 
      cto.reshape(75, 118, 310, 35);
      camt.reshape(432, 106, 100, 35);
      cnum.reshape(472, 18, 60, 30);
      cdate.reshape(308, 45, 140, 35);
      cfor.reshape(52, 185, 200, 30);

      button1.reshape(34, 190, 100, 30);
      //button2.reshape(151, 190, 100, 30);
      button3.reshape(292, 190, 100, 30);
      button4.reshape(412, 190, 100, 30);
      ok.reshape(460, 180, 70, 40);

      pup.reshape(510, 40, 20, 20);
      up.reshape(510, 80, 20, 20); 
      dn.reshape(510, 120, 20, 20);
      pdn.reshape(510, 160, 20, 20); 

      refresh();

   }

   public boolean action(Event evt, Object arg)
   {
      if(evt.target instanceof Button)
      {
         handleButton((String)arg);
         return true;
      }
      if(evt.target instanceof Checkbox)
      {
         handleBox();
         return true;
      }
      return true;
   }

   void loadCheck(Transaction t)
   {
      cdate.setText(goodDate(t.date));
      cnum.setText(new Integer(t.transactionID).toString()); 
      cto.setText(t.recipient);
      cfor.setText(t.category);
      camt.setText(new Double(0-t.amount).toString());
      
   } 
 
   void handleBox()
   { 
      if((getSelectedCheckbox() + offset) <
 		globalAccount.transactions.tCollection.size())
         loadCheck(globalAccount.transactions.returnTransaction(
                                getSelectedCheckbox() + offset));   
   }

   void clearCheck()
   {
      camt.setText("");
      cto.setText("");
      cfor.setText("");
      cnum.setText("");
      cdate.setText("");
      
   }

   public Transaction toTrans()
   {
      boolean valid = true;
      Double amount;
      Date date;
      Integer i;

      try  
      date = new Date(cdate.getText());
      catch (IllegalArgumentException e)
      {
         date = new Date();
      }

      try
	 amount = new Double(camt.getText());
      catch (NumberFormatException e)
      {
         amount = new Double(0);
         camt.setText("");
         valid = false;
      }

      try
         i = new Integer(cnum.getText());
      catch (NumberFormatException e)
      {
         i = new Integer(0);
         cnum.setText("");
         valid = false;
      }

      if(valid)
      {      
         date.setMonth(date.getMonth()-1);
         Transaction t = new Transaction();
         t.transactionID = i.intValue();
         t.recipient = cto.getText();
         t.category = cfor.getText();
         t.amount = (0 - amount.doubleValue());
         t.date = date;
         return t;
      }
      else
         return null;

   }

   String goodDate(Date d)
   {
      String str = new String((d.getMonth() + 1) + "/" + d.getDate() +
                 "/" + d.getYear());
      return str;
         
   } 

   int getSelectedCheckbox()
   {
      int found = -1;
      for(index = 0; index < 5; index++)
        if(cb[index] == cg.getCurrent())
          found = index;   
      return found;
   }

   void handleButton(String str)
   {

      if(str.equals("OK"))
      {  
         Transaction t;
         t = toTrans(); 
         if(t == null)
         {
 	    clearCheck();
         }
         else
         {
            globalAccount.transactions.addTransaction(t);
            globalAccount.reCalcBalance();
            clearCheck();
            refresh();
         }
      }  

      if(str.equals("New"))
      { 
         clearCheck();
      }

      //if(str.equals("New Withdrawl"))
      //{
      //   clearCheck();
      //}
  
      if(str.equals("Delete"))
      {
         globalAccount.transactions.removeTransactionAt(offset + 
                      getSelectedCheckbox());
         globalAccount.reCalcBalance();
         clearCheck();
         cb[5].setState(true);
         refresh();
      }

      if(str.equals("Return"))
      {
         parent.LoadSplashScreen();
      }

      if(str.equals("pup"))
      {
         offset -= 5;
         if (offset < 0 ) 
            offset = 0;
         clearCheck();
         cb[5].setState(true);
         refresh();

      }

      if(str.equals("pdn"))
      {
         offset += 5;
         if (offset > globalAccount.transactions.tCollection.size() - 1)
            offset = globalAccount.transactions.tCollection.size() -1;
         clearCheck();
         cb[5].setState(true);
         refresh();
      }

      if(str.equals("up"))
      { 
         if(offset > 0)
 	    offset--;
         clearCheck();
         cb[5].setState(true);
         refresh();
      }

      if(str.equals("dn"))
      {
         if(offset < globalAccount.transactions.tCollection.size() - 1) 
            offset++;
         clearCheck();
         cb[5].setState(true);
         refresh();
      }


   }

}
