// Class: PicturePanel
// Author: Jason Pastor
// Last Modified: 5/08/96

import java.awt.*;

public class PicturePanel extends Panel
// This class is an extension of the Panel class.  It is designed
// to provide sub-classes two panels properly aligned with a designated
// image.  Although an instance of this class could be used, it is better
// fit to be a superclass of a section of a larger program.  
//
// Note: For maximum compatability, no action methods are overridden. 
//	   This provides easy control for the parent class if determined
//	   necessary by the subclass.
//       This class might also be enhanced to support resizing.


{
	public Panel top = new Panel();	// Top Panel
	public Panel bottom = new Panel();	// Bottom Panel
	Image canvaspict;				// Outline Image
	//Layout For Panels
	GridLayout panelLayout = new GridLayout(2,1,10,12);
	//GridBagConstraints for panels
	GridBagConstraints layoutConstraints = new GridBagConstraints();
	
	PicturePanel(Image picture) 
	// This constructor must be passed the Image to be used as the
	// Outline of the PicturePanel
	{
	    // Perform Panel constructor operations
	    super();
	    // Use global for other methods
	    canvaspict = picture;
	    setLayout(panelLayout);
	    // Create the Top and bottom panels
	    add(top);
	    add(bottom);

	}
	public void paint(Graphics g)
	{
		g.drawImage(canvaspict,0,0,this);
	                
	}
	public Insets insets() 
	// This method overides the Insets method in Panel
	// in order to properly alignt the top and bottom panels
	// with the image.
	{
		return new Insets(8,10,15,90);
	}
        
}

