
import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

class User {

	static String host;     // This must be set to the HTTP Server host (ex. "acmex.gatech.edu")
	Vector accounts;
	String userID;
	String name;

	private char firstChar;
	private String filename, line, element, tempString;
	private static String sfilename, sline;
	private static final int PORT = 4444;
    private Socket s;
	private static Socket ss;
    private DataInputStream in;
	private static DataInputStream sin;
    private PrintStream out;
	private static PrintStream sout;
	private Account acc, tempAcc;
	private Transaction t, tempTran;
	private Vector trans;
	private String acclist;
	private Double tempDouble;         // Notic this is Double not double
	private Integer	tempInt;

	public User() {
		accounts = new Vector();
	}
	
	public static boolean findUser(String uID) {
		
		try {
            ss = new Socket(User.host, PORT);
            sin = new DataInputStream(ss.getInputStream());
            sout = new PrintStream(ss.getOutputStream());	
		} catch (Exception e) {
		    System.out.println("Socket Connection Error: " + e);
		}

		sfilename = uID + ".IF";
	
		sout.println("find " + sfilename);

		try {
			while ((sline = sin.readLine()) == null) {}
		} catch (IOException e) {
			System.out.println("Socket IO Error: " + e);
			return false;
		}	

		if (sline.equals("TRUE")) return true;
		if (sline.equals("FALSE")) return false;
		return false;
	} /* findUser */

	public void loadUser(String uID) {
		// System.out.println("loadUser called with " + uID);
		// System.out.println("host: " + User.host);

		try {
            s = new Socket(User.host, PORT);
            in = new DataInputStream(s.getInputStream());
            out = new PrintStream(s.getOutputStream());	
		} catch (Exception e) {
		    System.out.println("Socket Connection Error: " + e);
		}

		filename = uID + ".IF";
	
		out.println("load " + filename);

		try {
			while (!(line = in.readLine()).equals("LOAD")) {
				 // System.out.println("Waiting on Server to return \"LOAD\"");
			} 
			// System.out.println("Got \"LOAD\" from Server..");
			tempAcc = new Account();
			
		   while (!(line.equals("*done*"))) { 
		 	while ((line = in.readLine()) != null) {
			   if (line.equalsIgnoreCase("*done*")) break;
			   try {
				firstChar = line.charAt(0);
				element = line.substring(1,9);
			   } catch (Exception e) { firstChar = ' ';}
				// System.out.println("<READING> " + firstChar + "." + element);
				if (firstChar == '+') {		// Process Line

					if (element.equalsIgnoreCase("name    ")) this.name = line.substring(9);
			 		if (element.equalsIgnoreCase("userID  ")) this.userID = line.substring(9);
					if (element.equalsIgnoreCase("account ")) tempAcc = new Account();
					if (element.equalsIgnoreCase("endacc  ")) this.accounts.addElement(tempAcc);
					if (element.equalsIgnoreCase("accname ")) tempAcc.name = line.substring(9);
					if (element.equalsIgnoreCase("owner   ")) tempAcc.owner = line.substring(9);
					if (element.equalsIgnoreCase("ir      ")) {
						tempString = line.substring(9);
					  try {	
					  	tempDouble = Double.valueOf(tempString);
						tempAcc.interestRate = tempDouble.doubleValue();
					  } catch (Exception e) tempAcc.interestRate = 0.0;
					}
					if (element.equalsIgnoreCase("balance ")) {
						tempString = line.substring(9);
					  try {
					    tempDouble = Double.valueOf(tempString);
						tempAcc.balance = tempDouble.doubleValue();
					  } catch (Exception e) tempAcc.balance = 0.0;
					}
					if (element.equalsIgnoreCase("trans   ")) tempTran = new Transaction();
					if (element.equalsIgnoreCase("endtrans")) 
							tempAcc.transactions.tCollection.addElement(tempTran);
					if (element.equalsIgnoreCase("transid ")) {	
						tempString = line.substring(9);
						try {
							tempInt = Integer.valueOf(tempString);
							tempTran.transactionID = tempInt.intValue();
						} catch (Exception e) tempTran.transactionID = 0;
					}
					if (element.equalsIgnoreCase("rec     ")) tempTran.recipient = line.substring(9);
					if (element.equalsIgnoreCase("amount  ")) {
						tempString = line.substring(9);
						try {
							tempDouble = Double.valueOf(tempString);
							tempTran.amount = tempDouble.doubleValue();
						} catch (Exception e) tempTran.amount = 0.0;
					}
					if (element.equalsIgnoreCase("date    ")) {
						tempTran.date = new Date(line.substring(9));
						// System.out.println("DATE: " + tempTran.date);
					}

					if (element.equalsIgnoreCase("cat     ")) tempTran.category = line.substring(9);

					
				} /*if */ 
				out.println("OK");  // HandShaking
		 	} /* while line */
		 	
		   } /* while not *done* */

		} catch (IOException e) {
			System.out.println("Error Reading from Server: " + e);
		} /* catch */	
		
		out.println("OK"); // Tell Server Loading is done
		try { 
			out.close();
			in.close();
			s.close();
		} catch (Exception e);
	} /* loadUSer */

	public void saveUser () {

		String uID = this.userID;

		try {
            s = new Socket(User.host, PORT);
            in = new DataInputStream(s.getInputStream());
            out = new PrintStream(s.getOutputStream());	
		} catch (Exception e) {
		    System.out.println("Socket Connection Error: " + e);
		}

		filename = uID + ".IF";
	
		out.println("save " + filename);

		try {
			while (!(line = in.readLine()).equals("SAVE")) {
				// System.out.println("Waiting on Server to return \"SAVE\"");
			}		
			// System.out.println("Got \"SAVE\" from Server");
			out.println("+name    " + name);
			out.println("+userID  " + userID);

			// System.out.println("accounts.size: " + accounts.size());
			for (int count=0;count < accounts.size();count++) {	
			    acc = (Account)accounts.elementAt(count);
				trans = acc.transactions.tCollection;
				out.println("--------------------------------------------------");
				out.println("+account ");
				out.println("+balance " + acc.balance);
				out.println("+ir      " + acc.interestRate);
				out.println("+accname " + acc.name);
				out.println("+owner   " + acc.owner);
				out.println("transsize = " + trans.size());
				for (int count2=0;count2 < trans.size();count2++) {
					t = (Transaction)trans.elementAt(count2);
					out.println("--------------------------");
					out.println("+trans   ");
					out.println("+transid " + t.transactionID);
					out.println("+rec     " + t.recipient);
					out.println("+amount  " + t.amount);
					out.println("+date    " + t.date);
					out.println("+cat     " + t.category);
					out.println("+endtrans");
					out.println("--------------------------");
				} /* for trans */
				out.println("+endacc  ");
				out.println("--------------------------------------------------");
			} /* for accounts */

 			out.println("*done*");
			out.flush();

		} catch (IOException e) {
			System.out.println("Error Writing to Server: " + e);
		} /* catch */

		try { 
			out.close();
			in.close();
			s.close();
		} catch (Exception e);
	
	} /* saveUser */

	public String toString() { 
	 	acclist = new String();
	  	for (int count=0;count < accounts.size();count++) {
			acc = (Account)accounts.elementAt(count);
			trans = acc.transactions.tCollection;
			acclist = acclist + "\nACCOUNT #"+count+": " + acc.toString();
			for (int count2=0;count2 < trans.size();count2++) {
			    t = (Transaction) trans.elementAt(count2);
				acclist = acclist + "\n  TRANS #"+count2+": " + t.toString();
			} /* for */
	  	} /* for */
		return ("NAME: "+name+" USERID: "+userID + acclist);
	} /* toString */

} /* User */

