
import java.io.*;
import java.net.*;

public class IFServer extends Thread {
    public final static int DEFAULT_PORT = 4444;
    protected int port;
    protected ServerSocket listen_socket;
    
    // Exit with an error message, when an exception occurs.
    public static void fail(Exception e, String msg) {
        System.err.println(msg + ": " +  e);
        System.exit(1);
    }
    
    // Create a ServerSocket to listen for connections on;  start the thread.
    public IFServer(int port) {
        if (port == 0) port = DEFAULT_PORT;
        this.port = port;
        try { listen_socket = new ServerSocket(port); }
        catch (IOException e) fail(e, "Exception creating server socket");
        System.out.println("Server: listening on port " + port);
        this.start();
    }
    
    // The body of the server thread.  Loop forever, listening for and
    // accepting connections from clients.  For each connection, 
    // create a Connection object to handle communication through the
    // new Socket.
    public void run() {
        try {
            while(true) {
                Socket client_socket = listen_socket.accept();
                IFConnection c = new IFConnection(client_socket);
            }
        }
        catch (IOException e) fail(e, "Exception while listening for connections");
    }
    
    // Start the server up, listening on an optionally specified port
    public static void main(String[] args) {
        int port = 0;
        if (args.length == 1) {
            try port = Integer.parseInt(args[0]); 
            catch (NumberFormatException e) port = 0;
        }
        new IFServer(port);
    }
}

// This class is the thread that handles all communication with a client
class IFConnection extends Thread {
    protected Socket client;
    protected DataInputStream in;
    protected PrintStream out;

	private static final String PATH = "./";
    private static PrintStream pos;
    private static DataInputStream pis;
    private static char command = ' ';
    private static PrintStream os;
    private static DataInputStream is;
    private static String fileName = null; 
	private static String line, inline;
	private int done;

    // Initialize the streams and start the thread
    public IFConnection(Socket client_socket) {
        client = client_socket;
        try { 
            in = new DataInputStream(client.getInputStream());
            out = new PrintStream(client.getOutputStream());
        }
        catch (IOException e) {
            try client.close(); catch (IOException e2) ;
            System.err.println("Exception while getting socket streams: " + e);
            return;
        }
        this.start();
    }
    
    // Provide the service.
    // Read Command, then Save or Load or Find.  
    public void run() {
          System.out.println("Connection made");
		try {
                // read in a line
                line = in.readLine();
				// get command from line
                try {
					command = line.charAt(0); 
        			fileName = line.substring(5);
				// System.out.println("Received: " + command + " " + fileName);
				} catch (Exception e) {
					System.out.println("Bad Command received");
					out.println("INVALID");
				} 


  		File theFile = new File(PATH, fileName);
		
		switch (command) {

		   case 's': {	     /* Save */

			if (theFile.exists()) {				  // If file exists delete it
				theFile.delete();
            }
           	try { 
				pos = new PrintStream(new FileOutputStream(PATH + fileName));
				out.println("SAVE");

			} catch (IOException e) {
				out.println("ERROR");
			}
			   // write header
			   pos.println("  ****************************\r");
			   pos.println("  * InstantFinance data file *\r");
			   pos.println("  ****************************\r");

			   try {
            	// read in data until line = "*done*"
				done = 0;
				while (done != 1) {
					while ((line = in.readLine()) != null) {
						pos.println(line + '\r');
						if (line.equals("*done*")){ 
						 	done = 1;
						 	break;
						}
						// System.out.println("-----" + line + "-----");
					}
				}
			   } catch (IOException e) {
				 out.println("ERROR");
				 System.out.println("Error when reading from Socket: " + e);
			   } 
		   // close file
		   pos.close();

		   } break;  

		   case 'l': {	     /* Load */
			line = " ";
			inline = " ";
			if (theFile.exists()) {
			   try { 
				pis = new DataInputStream(new FileInputStream(PATH + fileName));
				out.println("LOAD");
			   } catch (IOException e) {
			    System.out.println("File Error: " + e);
				out.println("ERROR");
			   }

			   try {
			   	// load data from file until line = *done*
			   	while (!(line.equals("*done*"))) {
					line = pis.readLine();
					out.println(line);
					// System.out.println("Sending: " + line);
					while (!(inline.equals("OK"))) {
						inline = in.readLine();
						if (inline == null) inline = " ";
						// System.out.println("Waiting on ACK");
					}
					 inline = " ";
					 // System.out.println("GOT ACK");
			   	}
			   } catch (IOException e) {
			   	 out.println("ERROR");
			   }
            }
			else {
				out.println("ERROR");
			}	

			
		   // close file
		   try  pis.close(); catch (IOException e);

		   } break;

		   case 'f': {	     /* Find */

			if (theFile.exists()) {
				out.println("TRUE");
				// System.out.println("TRUE");
			}
			else {
				out.println("FALSE");
				// System.out.println("FALSE");
			}
           		
		   } break;

		   default: {
			out.println("INVALID2");
		   }

		} /* Switch command */

            }  /* try */
        catch (IOException e) System.out.println("Could not Read from Client: " + e) ;
      
	    System.out.println("Connection Done");
    } /* run() */

} /* IFConnection */
