//=======================================================================
// File   : ChartUI.java    
// Author : Jian Liang (jian.liang@ebay.sun.com)
// Date   : 1/30/96
// Version: 1.0 ( for Beta2 JDK API)
//
// All Right Reserved. 
//
// applet to create chart. User Interface is created if parameters 
// not provided.
//
//=======================================================================

import java.awt.*;
import java.applet.Applet;
import java.io.*;
import java.lang.*;
import java.util.Date;
import java.util.Vector;
import java.lang.Math;
import User;
import Account;
import TransactionCollection;


//import PicturePanel;

public class ChartUI extends PicturePanel
{    
   private AllChart  m_ChartCanvas = null;
  // private PicturePanel pictPanel = null;
   private Choice    m_ChartType = null;
   private Choice    m_LocationType = null;
   private TextField m_Location = null;
   private TextField tValue1 = null;
   private TextField tValue2 = null;
   private TextField tValue3 = null;
   private TextField tValue4 = null;
   private TextField tValue5 = null;
   private TextField tTitle = null;
   private TextField tLabel1 = null;
   private TextField tLabel2 = null;
   private TextField tLabel3 = null;
   private TextField tLabel4 = null;
   private TextField tLabel5 = null;
   private Panel pnlMainControl = null;
   private Panel pnlDynamicControl = null;   
   private Panel pnlBudget = null;
   private Panel pnlBalance = null;	
   private User CurrentUser = null;
   private TextField txtBeginDate = null; 
   private TextField txtEndDate = null;
   private Choice chcAccountChoice = null;
   private List lstCategory = null; 
   private Vector vctCatValues = null;
   private Vector vctCatLabels = null;
 
   //------------------------------------------------------------------------
   // METHOD: init
   //
   //       overwrite Applet.init()
   //
   // PARAMETERS: none.
   //
   // RETURN:  none.
   //------------------------------------------------------------------------   
   public ChartUI(Image picture, User InUser) 
   {       
	super(picture);
	CurrentUser = InUser;
      // setLayout(new GridLayout(2,1));
      int Index;
      // upper static panel 
      // Panel p0 = new Panel();  
      pnlMainControl = new Panel();
      pnlDynamicControl = new Panel();
      pnlBudget = new Panel();
	pnlBudget.setLayout(new GridLayout(7,1));
	pnlBalance = new Panel();
	pnlBalance.setLayout(new GridLayout(7,1));
      

      GridBagLayout layLeft = new GridBagLayout();
	GridBagConstraints cLeft = new GridBagConstraints();

      m_ChartType = new Choice();  
	//pictPanel = p0;
	tValue1 = new TextField("10",20);
	tValue2 = new TextField("20",20);
	tValue3 = new TextField("30",20);
	tValue4 = new TextField("30",20);
	tValue5 = new TextField("25",20);
	tTitle = new TextField("Monthly Expenditures for March",20);
	tLabel1 = new TextField("Food",20);
      tLabel2 = new TextField("Tuition",20);
      tLabel3 = new TextField("Car",20);
	tLabel4 = new TextField("Utilities",20);
	tLabel5 = new TextField("Other",20);
      m_ChartType.addItem("Balance");
      m_ChartType.addItem("Budget");
      // m_ChartType.addItem("Expenditures");

      top.setLayout(new GridLayout(1,2));
      top.add(pnlMainControl);
      top.add(pnlDynamicControl); 

	pnlMainControl.setLayout(layLeft);
	pnlDynamicControl.setLayout(new CardLayout());
	pnlDynamicControl.add("one", pnlBalance);
	pnlDynamicControl.add("two", pnlBudget);

	//cLeft.insets = layLeft.Insets(0,0,0,0);
	cLeft.fill = GridBagConstraints.HORIZONTAL;
	cLeft.gridx = 0;
	cLeft.gridy = 0;
	cLeft.weightx = 1;
	cLeft.weighty = 1;
	cLeft.gridy = GridBagConstraints.RELATIVE;
	cLeft.gridx = GridBagConstraints.RELATIVE;

	cLeft.gridwidth = GridBagConstraints.REMAINDER;
	Label lblReportManager = new Label("Report Manager",Label.CENTER);
	layLeft.setConstraints(lblReportManager,cLeft);
	pnlMainControl.add(lblReportManager);

	cLeft.gridwidth = 1;
	Label lblAccountChoice = new Label("Account:",Label.RIGHT);
	layLeft.setConstraints(lblAccountChoice,cLeft);
	pnlMainControl.add(lblAccountChoice);
	

//	cLeft.weightx = 3;
	cLeft.gridwidth = GridBagConstraints.REMAINDER;
	chcAccountChoice = new Choice();
	layLeft.setConstraints(chcAccountChoice,cLeft);
	pnlMainControl.add(chcAccountChoice);
	
	//chcAccountChoice.addItem("Jason");
	//chcAccountChoice.addItem("Pastor");
	for (Index = 0; Index < CurrentUser.accounts.size(); Index++){
	    chcAccountChoice.addItem(((Account)CurrentUser.accounts.elementAt(Index)).name);
	}

//	cLeft.weightx = 1;
	cLeft.gridwidth = 1;
      Label lblChartType = new Label("Chart Type:",Label.RIGHT);
 	layLeft.setConstraints(lblChartType,cLeft);
      pnlMainControl.add(lblChartType);      
      
  	cLeft.gridwidth = GridBagConstraints.REMAINDER;
      layLeft.setConstraints(m_ChartType,cLeft);
      pnlMainControl.add(m_ChartType);

	layLeft.setConstraints(tTitle,cLeft);
      pnlMainControl.add(tTitle);

	cLeft.gridwidth = GridBagConstraints.RELATIVE;
//	cLeft.weightx = 1;      
	Label lblBeginDate = new Label("Begin Date:",Label.CENTER);
	layLeft.setConstraints(lblBeginDate,cLeft);
	pnlMainControl.add(lblBeginDate);
	cLeft.gridwidth = GridBagConstraints.REMAINDER;
	Label lblEndDate = new Label("End Date:",Label.CENTER);
	layLeft.setConstraints(lblEndDate,cLeft);
	pnlMainControl.add(lblEndDate);

	cLeft.gridwidth = GridBagConstraints.RELATIVE;
//	cLeft.weightx = 1;      
	txtBeginDate = new TextField("01/01/96",8);
	layLeft.setConstraints(txtBeginDate,cLeft);
	pnlMainControl.add(txtBeginDate);
	cLeft.gridwidth = GridBagConstraints.REMAINDER;
	txtEndDate = new TextField("12/12/96",8);
	layLeft.setConstraints(txtEndDate,cLeft);
	pnlMainControl.add(txtEndDate);


	Button butNewChart = new Button("New Chart");
	layLeft.setConstraints(butNewChart,cLeft);
      pnlMainControl.add(butNewChart);      
	
	lstCategory = new List();
	lstCategory.addItem("No Categories");
	lstCategory.setMultipleSelections(true);
        vctCatLabels = new Vector();
	vctCatValues = new Vector();
	createList((Account)(CurrentUser.accounts.elementAt(0)));
	pnlBudget.setLayout(new GridLayout(2,1));
        pnlBudget.add(lstCategory);

      //add("North", pictPanel );
      
      // lower panel displayed if parameter is not given
            
   //         createNewChart();
      

     // add("South", p1 );                
   }


public void createList(Account theAccount){
    int index = 0;
    Transaction currentTransaction;
    int lstIndex = 0;
    lstCategory.clear();
    vctCatValues.removeAllElements();
    vctCatLabels.removeAllElements();
    for (index = 0; index < theAccount.transactions.tCollection.size(); index++){
	currentTransaction = theAccount.transactions.returnTransaction(index);
    	lstIndex = vctCatLabels.indexOf(currentTransaction.category);
	if (lstIndex < 0) {
	    lstCategory.addItem(currentTransaction.category);
	    vctCatLabels.addElement(currentTransaction.category);
	    vctCatValues.addElement(new Double(0));
	    lstIndex = vctCatValues.size() - 1;
	}
	vctCatValues.setElementAt(new Double(Math.abs(currentTransaction.amount)+((Double)vctCatValues.elementAt(lstIndex)).doubleValue()),lstIndex);
   }
}

public void updateList(Account theAccount){
    int index = 0;
    Transaction currentTransaction;
    int lstIndex = 0;
    for (index = 0; index < theAccount.transactions.tCollection.size(); index++){
        currentTransaction = theAccount.transactions.returnTransaction(index);
        lstIndex = vctCatLabels.indexOf(currentTransaction.category);
        if (lstIndex < 0) {
            lstCategory.addItem(currentTransaction.category);
            vctCatLabels.addElement(currentTransaction.category);
            vctCatValues.addElement(new Double(0));
	    lstIndex = vctCatValues.size() -1;
        }
        vctCatValues.setElementAt(new Double(Math.abs(currentTransaction.amount)+((Double)vctCatValues.elementAt(lstIndex)).doubleValue()),lstIndex);
   }
}

	 
   //------------------------------------------------------------------------
   // METHOD: action
   //
   //       overwrite Component.action(...)
   //
   // PARAMETERS: evt - the event 
   //             arg - the action that's occuring 
   //
   // RETURN:  see manual.
   //------------------------------------------------------------------------   
   public boolean action(Event evt, Object arg)
   {
	   System.out.println("In action...\n");
     if (evt.target instanceof Button)
     {
        Button b = (Button)evt.target;

        if ( b.getLabel() == "New Chart" ) createNewChart(); 
        return true;
     }
     else if (evt.target instanceof Choice)
     {
        System.out.println("Choice... " + arg.toString() + "\n");
	if ((Choice)evt.target == m_ChartType){
	  if ("Budget".equals(arg)) {
	      ((CardLayout)pnlDynamicControl.getLayout()).show(pnlDynamicControl,"two");
	  }
	  else
	  	  if ("Balance".equals(arg)) {
	      ((CardLayout)pnlDynamicControl.getLayout()).show(pnlDynamicControl,"one");
	  }
	}
	else
	{
	 createList((Account)(CurrentUser.accounts.elementAt(chcAccountChoice.getSelectedIndex())));
	}


//        if ( (Choice)evt.target == m_ChartType ) createNewChart();
//        return true;

     }

     return false;
   }

public String toLabel(Date inDate){
    String temp;
    switch (inDate.getMonth() - 1){
	case 1:
	    temp = "Jan ";
	    break;
        case 2:
            temp = "Feb ";
            break;
        case 3:
            temp = "Mar ";
            break;
        case 4:
            temp = "Apr ";
            break;
        case 5:
            temp = "May ";
            break;
        case 6:
            temp = "Jun ";
            break;
        case 7:
            temp = "Jul ";
            break;
        case 8:
            temp = "Aug ";
            break;
        case 9:
            temp = "Sep ";
            break;
        case 10:
            temp = "Oct ";
            break;
        case 11:
            temp = "Nov ";
            break;
        case 12:
            temp = "Dec ";
            break;
	default:
	    temp = "XXX ";
    }
    return (temp + inDate.getYear());
}

public Date searchInc(Date inDate){
    inDate.setMonth(inDate.getMonth()+1);
    if (inDate.getMonth() > 13) {
        inDate.setMonth(inDate.getMonth() - 12);
        inDate.setYear(inDate.getYear() + 1);
    }
    return inDate;
}

public Date monthInc(Date inDate){
    inDate.setMonth(inDate.getMonth()+1);
    if (inDate.getMonth() > 12) {
        inDate.setMonth(inDate.getMonth() - 12);
	inDate.setYear(inDate.getYear() + 1);
    } 
    return inDate;
}

   //------------------------------------------------------------------------
   // METHOD: createNewChart
   //
   //       create a new chart in proper type.
   //
   // PARAMETERS: none.
   //
   // RETURN:  none.
   //------------------------------------------------------------------------   
   public  void createNewChart()
   {
	System.out.println("In createNewChart()\n");
      String dataSource = "BLAH";
      String chartType = m_ChartType.getSelectedItem();
      
    String sTmp = "BLAH";
    int index = 0;
    boolean done = false;
    int locationType = 0;
    int i=0,m_NumofPoints = 5;
    Date beginDate, endDate, searchDate;
    Account currentAccount;
    Transaction currentTransaction;
    double currentBalance = 0;
    Vector vctLabels = new Vector();
    Vector vctValues = new Vector();
    beginDate = new Date(txtBeginDate.getText());
    endDate = new Date(txtEndDate.getText());
    String XLabels[];
    float YValues[];
    if (chartType.equals("Balance")){
        currentBalance = ((Account)CurrentUser.accounts.elementAt(chcAccountChoice.getSelectedIndex())).balance;
	beginDate.setDate(1);
	//beginDate.setMonth(beginDate.getMonth()+1);
	beginDate = monthInc(beginDate);
	endDate.setDate(1);
	//endDate.setMonth(endDate.getMonth()+1);
	endDate = monthInc(endDate);
	currentAccount = (Account)CurrentUser.accounts.elementAt(chcAccountChoice.getSelectedIndex()); 
	done = false;
	searchDate = beginDate;
	while (!(done)) {
	    if (index < currentAccount.transactions.tCollection.size())	{
	        currentTransaction = currentAccount.transactions.returnTransaction(index++);
	        if ((currentTransaction.date).before(searchDate)) {
         	    currentBalance = currentTransaction.balance;
	        }
	        else index--;
	    }
	    System.out.println(toLabel(searchDate)+"Month: "+(searchDate.getMonth()-1)+" Year: "+searchDate.getYear()+" Balance: "+currentBalance);
	    vctLabels.addElement(toLabel(searchDate));
	    vctValues.addElement(new Double(currentBalance));
	    //searchDate.setMonth(searchDate.getMonth()+1);
	    searchDate = searchInc(searchDate);
	    done = (searchDate.after(endDate));
	}
    } 
    else{
	if ((lstCategory.getSelectedIndexes().length) < 1) {
	    vctLabels = vctCatLabels;
	    vctValues = vctCatValues;
	}
	else{
	    for(index = 0;index < vctCatLabels.size();index++){
	        if (lstCategory.isSelected(index)) {
	            vctLabels.addElement(vctCatLabels.elementAt(index));
	            vctValues.addElement(vctCatValues.elementAt(index));
	        }
            }
	} 
    }
     
      m_NumofPoints = vctLabels.size();  
      XLabels = new String[m_NumofPoints];
	YValues = new float[m_NumofPoints];
      for (index = 0; index < m_NumofPoints; index++){
	  XLabels[index] = (String) vctLabels.elementAt(index);
	  YValues[index] = ((Double) vctValues.elementAt(index)).floatValue();
      }
      if ( m_ChartCanvas != null ) {          
          bottom.remove(m_ChartCanvas);
      }
      if ( chartType.equals("Balance") ) 
      {
         m_ChartCanvas = new LineChart();
      }
      else if ( chartType.equals("Budget") )
      {
         m_ChartCanvas = new PieChart();
      }
      else if ( chartType.equals("Expenditures") ) 
      {
         m_ChartCanvas = new ThreeDVBarChart();
      }
      else return;
      bottom.setLayout(new GridLayout(1,1));
      bottom.add(m_ChartCanvas );      
      m_ChartCanvas.initChart(tTitle.getText(),XLabels,YValues);
      bottom.validate();
   }   
  
}

