//=======================================================================
// File   : AllChart.java    
// Author : Jian Liang (jian.liang@ebay.sun.com)
// Date   : 01/30/96
// Version: 1.0 ( for Beta2 JDK API)
//
// All Right Reserved. 
//
// Chart generator.An abstract class. Supports H-Bar, V-Bar, Line and Pie
// chart generation.
//
//=======================================================================

import java.applet.Applet;
import java.awt.*;
import java.io.*;
import java.lang.*;
import java.net.*;

abstract class AllChart extends Canvas {

    //---title--------------
    String  m_ChartTitle = "";    
    
    //---Fonts--------------
    Font        m_TitleFont = new Font("Courier", Font.BOLD, 16 );  
    FontMetrics m_TitleMetrics = getFontMetrics(m_TitleFont); 
    Font        m_LabelFont = new Font("Courier", Font.BOLD, 12 );
    FontMetrics m_LabelMetrics = getFontMetrics(m_LabelFont);
    Font        m_yLabelFont = new Font("Courier", Font.BOLD, 12 );
    FontMetrics m_yLabelMetrics = getFontMetrics(m_yLabelFont);


    //---Chart positions----
    int   m_TitleCy = m_TitleMetrics.getHeight() * 2;
    int   m_MarginCx= 0;
    int   m_MarginCy= 0;

    //---Data array---------
    int   m_NumofPoints = 0 ;
    String      m_XLabels[];
    float       m_YValues[];
    
    //---Off Screen painting---
    Image     m_OffImage    = null;
    Graphics  m_OffGraphics = null;
    Dimension m_LastSize    = new Dimension(0,0); //modify only if resized

    //------------------------------------------------------------------------
    // METHOD: initChart 
    //
    //       initialize chart information: retrieve chart data from an URL source
    //       or a Chart Server and calculate chart margin size.
    //
    // PARAMETERS: dataSource - and URL or ChartServer ID. When ChartServer ID 
    //                          is given, the format of <hostname:portnum>
    //                          is required. ( such as canton.ebay.sun.com:5000 )
    //             connectionType - 0 for URL, 1 for ChartServer
    //
    // RETURN:  true if successful, false if error
    //------------------------------------------------------------------------
    public synchronized boolean initChart( String Title, String[] XLabels, float[] YValues)
    {
       m_NumofPoints = XLabels.length;
       m_XLabels = null;
       m_YValues = null;
       m_ChartTitle = " ";
       setBackground(Color.white);
               
           m_ChartTitle = Title;

           String sTmp ;
           int i;
        
           // m_NumofPoints  = 5;           
           m_XLabels = new String[m_NumofPoints];
           m_YValues = new float[m_NumofPoints];
	     m_YValues = YValues;
	     m_XLabels = XLabels;
	      //arraycopy(XLabels,1,m_XLabels,1,5);
	     //arraycopy(YValues,1,m_YValues,1,5);
      calculateMargin();   
	return true;
    }


    //------------------------------------------------------------------------
    // METHOD: parseInputStream
    //
    //       parse chart data received from an InputStream, store chart data
    //       into m_XLabel[] and m_YValues[].
    //
    // PARAMETERS: istream - where the chart data come from.
    //
    // RETURN:  true if successful, false if error
    //------------------------------------------------------------------------
    protected synchronized boolean parseInputStream()
    {       
        return true;
    }

    //------------------------------------------------------------------------
    // METHOD: drawChartTitle
    //
    //       called by sub-classes to draw title at top-center.
    //
    // PARAMETERS: g - the Graphics object to be drawn on.
    //
    // RETURN:  none.
    //------------------------------------------------------------------------
    protected  void drawChartTitle(Graphics g)
    {   
       int tWidth  = m_TitleMetrics.stringWidth(m_ChartTitle);
       int iHeight = m_TitleMetrics.getHeight() ;

       g.setColor(Color.black);
       g.setFont(m_TitleFont);
       g.drawString(m_ChartTitle, 
                    Math.max( (size().width - tWidth)/2, 0),
                    (int)(iHeight) ); 

    }

    
    //------------------------------------------------------------------------
    // METHOD: calculateMargin
    //
    //   abstract method to be implemented by sub-classes to initialize 
    //   m_MarginCx, m_MarginCy etc. based on chart features.
    //
    // PARAMETERS: g - the Graphics object to be drawn on.
    //
    // RETURN:  none.
    //------------------------------------------------------------------------
    abstract protected  void calculateMargin() ;
    
    //------------------------------------------------------------------------
    // METHOD: drawChart
    //
    //   abstract method to be implemented by sub-classes to 
    //   do actual chart drawing.
    //
    // PARAMETERS: g - the Graphics object to be drawn on.
    //
    // RETURN:  none.
    //------------------------------------------------------------------------
    abstract public void drawChart(Graphics g) ;

    //------------------------------------------------------------------------
    // METHOD: update
    //
    //   overwrite. Reduce flicking, no need to use background color.
    //
    // PARAMETERS: g - the Graphics object to be drawn on.
    //
    // RETURN:  none.
    //------------------------------------------------------------------------
    public void update(Graphics g) 
    {
       //removed clearRect from here
       paint(g);
    }

    //------------------------------------------------------------------------
    // METHOD: paint
    //
    //   overwrite. Reduce un-necessary painting
    //
    // PARAMETERS: g - the Graphics object to be drawn on.
    //
    // RETURN:  none.
    //------------------------------------------------------------------------
    public  void paint(Graphics g) 
    {
      if (m_LastSize.width  != size().width ||
          m_LastSize.height != size().height )  
      {  // ....first time or resized....
         
         m_LastSize = new Dimension(size());
         m_OffImage = createImage(size().width, size().height);
         m_OffGraphics = m_OffImage.getGraphics();

         m_OffGraphics.clearRect(0,0, size().width, size().height);
         drawChart(m_OffGraphics) ;
      }

      g.drawImage(m_OffImage,0,0,null);

    }

    //------------------------------------------------------------------------
    // METHOD: getBrightColor
    //
    //      called by sub-classes to get one of 10 bright colors used by
    //      charts.
    //
    // PARAMETERS: i - color index reference. 
    //
    // RETURN:  the Color object.
    //------------------------------------------------------------------------
    protected Color getBrightColor(int i) 
    {
       Color pickColor = Color.white;
       int   colorIndex = i - ((int)(i/10))*10;
          
       switch(colorIndex) {
         case 0:
           pickColor = Color.red ;
           break;
         case 1:
           pickColor =  Color.yellow ;
           break;
         case 2:
           pickColor =  Color.green ;
           break;
         case 3:
           pickColor =  Color.cyan ;
           break;
         case 4:
           pickColor =  Color.blue ;
           break;
         case 5:
           pickColor =  Color.magenta ;
           break;
         case 6:
           pickColor =  Color.orange ;
           break;
         case 7:
           pickColor =  Color.pink ;
           break;
         case 8:
           pickColor =  Color.lightGray ;
           break;
         case 9:
           pickColor =  Color.darkGray ;       
       } //switch

       
       colorIndex = (int) i / 10;       
       for ( int j = 0; j<colorIndex; j++)
       {
          pickColor = new Color( 
                  Math.abs(pickColor.getRed()-50),
                  Math.abs(pickColor.getGreen()-50),
                  Math.abs(pickColor.getBlue()-50) );                   
       }
       
       return pickColor;
    }

}

