#!/usr/bin/env bash
set -e

echo "=== HW0 Submission Collection Script ==="

# Create zip archive
echo "Creating zip archive..."
rm "hw0_code_submission.zip" || true

# Compress all relevant files into a single zip file
zip -r "hw0_code_submission.zip" main.py \
    -x '.venv/*' \
    -x '*__pycache__*' \
    -x '*ipynb_checkpoints*' \
    -x '*.csv' \
    -x '*.bin' \
    -x '*.pt' \
    -x '*.pth' \
    -x 'hw0_code_submission.zip'

echo "✓ Created hw0_code_submission.zip"

echo ""
echo "=== Submission Collection Complete ==="
echo "✓ Generated: hw0_code_submission.zip"
echo ""
echo "Please submit these files to Gradescope:"
echo "  - hw0_code_submission.zip"
echo ""
echo "Congratulations on completing the assignment!"