# A very simple setup script to create 2 executables.
#
# hello.py is a simple "hello, world" type program, which runs in the console
#
# canvasDemo.py is a simple program that uses the Tkinter package to make
# a simple line drawing tool. Left click to draw lines, right click to
# delete lines.
# It will be converted into a windows program WITHOUT a console!
#
#
# Run the build process by entering 'setup.py build' or
# 'python setup.py build' in a console prompt.
#
# Note: 'python setup.py bdist_msi' will create a MSI installer and put a shortcut
# to the canvasDemo program into the main program menu.
#
# If everything works well, you should find a subdirectory named 'dist'
# containing some files, among them hello.exe and canvasDemo.exe.


import sys
from cx_Freeze import setup, Executable


#Dependancies are automatically detected, but it might need some hints...
#re is needed by cx_Freeze
build_exe_options={"packages": ["re", 'tkinter']}

setup(
    # The first three parameters are not required, if at least a
    # 'version' is given, then a versioninfo resource is built from
    # them and added to the executables.
    version = "0.5.0",
    description = "csFreeze sample script",
    name = "csFreeze samples",

    options={"build_exe": build_exe_options},
    
    # targets to build - Try using base=None on the canvas Demo to see
    # a windows program WITH a consle!
    executables = [ Executable("canvasDemo.py", base="Win32GUI",
                        shortcutName="CanvasDemo",
                               shortcutDir="ProgramMenuFolder"),
                    Executable("hello.py", base=None)]
    
 
    )
