; install_script.nsi
;

;--------------------------------

; The name of the installer
Name "cxFreezeDemo"

; The file to write
OutFile "cxfdemo.exe"

; The default installation directory
InstallDir $PROGRAMFILES\cxFreezeDemo

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\cxFreezeDemo" "Install_Dir"

; Request application privileges for Windows Vista
RequestExecutionLevel admin

;

;Set compression level, but don't use solid to allow rsync updates to work
; faster for minor changes!


SetCompressor lzma


;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "Main Demo (required)"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Take all files, including recursive subdirectories!
  File /r "build\exe.win32-3.4\*"
  
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\cxFreezeDemo "Install_Dir" "$INSTDIR"
  
  ; Tell Vista that this program must be ran as administrator (so it can save
  
  ; it's state file in the install dir

  
  WriteRegStr HKLM "Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\layers" "$INSTDIR\canvasDemo.exe" "RUNASADMIN"


  WriteRegStr HKLM "Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\layers" "$INSTDIR\hello.exe" "RUNASADMIN"




   
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\cxFreezeDemo" "DisplayName" "cxFreeze Demo"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\cxFreezeDemo" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\cxFreezeDemo" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\cxFreezeDemo" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\cxFreezeDemo"
  CreateShortCut "$SMPROGRAMS\cxFreezeDemo\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\cxFreezeDemo\CanvasDemo.lnk" "$INSTDIR\canvasDemo.exe" "" "$INSTDIR\canvasDemo.exe" 0
  CreateShortCut "$SMPROGRAMS\cxFreezeDemo\Hello.lnk" "$INSTDIR\hello.exe" "" "$INSTDIR\hello.exe" 0
 
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\cxFreezeDemo"
  DeleteRegKey HKLM SOFTWARE\cxFreezeDemo

  ; Remove registry keys for admin run rights
  DeleteRegValue HKLM "Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\layers" "$INSTDIR\canvasdemo.exe" 
  DeleteRegValue HKLM "Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\layers" "$INSTDIR\hello.exe" 
  

  ; Remove files and uninstaller
  Delete $INSTDIR\*
  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\cxFreezeDemo\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\cxFreezeDemo"
  RMDir /r "$INSTDIR"

SectionEnd
