' Windows Script to configure environment variables for the Java SDK
' 
' Should work with any version Java SDK (past and future releases), tested on versions 1.4, 1.42, 1.5
'
' Change the constant minimumJavaVersion to prevent making any changes to the system, unless the JDK is equal to or greater
' than the value defined.
'
' Jon Kean (jkean3 at gatech.edu)
'
' Last edited on 2006-05-22
'
' Changes made by this script:
'
' the Java SDK 'bin' directory is added to the system file path (if not already present)
'
' JAVA_HOME environment variable is created if needed, with a value of the path to the SDK
' (some Java programs use this variable, such as Tomcat and Ant)
'

Option Explicit

' minimum version of the JDK the user should have, if the version is lower than this an MsgBox prompts the user to
' install the latest, and no changes are made to the system.
Const minimumJavaVersion = "1.6"

'Stop at all errors by default
On Error Goto 0

'AddToPath: If strAdd is not in strPath, then append strAdd to the end of strPath
Function AddToPath (strPath, strAdd)
  If (InStr(1, strPath, strAdd, 1) = 0) Then
    AddToPath = strPath & ";" & strAdd
  Else
    AddToPath = strPath
  End If
End Function

' check if the system environment variables have the Java SDK properly added, otherwise add them
Sub addJavaSDKEnvVars

  Dim WshShell, strPath, strOrigPath, strJavaVersion, strJavaPath, strJavaHomePath, strResult, changesMade
  Set WshShell = WScript.CreateObject("WScript.Shell")

  On Error Resume Next

  MsgBox vbCrLf & "This script will automatically add the Java SDK to your system environment variables", 0, "Java SDK environment Variable Setup"

  'Read the system path, and exit on errors
  strPath = WshShell.RegRead("HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\Path")
  If (err) Then
    MsgBox "Error: Could not read the system path from the registry"
    Exit Sub
  End If
  strOrigPath = strPath

  'Read the Java SDK path
  strJavaVersion = WshShell.RegRead("HKLM\SOFTWARE\JavaSoft\Java Development Kit\CurrentVersion")
  strJavaPath = WshShell.RegRead("HKLM\SOFTWARE\JavaSoft\Java Development Kit\" & strJavaVersion & "\" & "JavaHome")
  If (err) Then 
    MsgBox "Error: Could not find a Java SDK installed on this system" & vbCrLf & vbCrLf & "Please download and install the latest Java SDK from:" & vbCrLf & "http://java.sun.com"
    Exit Sub
  Else
    MsgBox "This system appears to have the Java SDK version: " & strJavaVersion & vbCrLf & vbCrLf & "Installed to the directory:" & vbCrLf & strJavaPath, 0, "Java SDK environment Variable Setup"
  End If

  If (strJavaVersion < minimumJavaVersion) Then
    MsgBox "ERROR: The JDK installed on this system is out of date." & vbCrlf & vbCrlf & "You need to uninstall the current JDK, and reinstall the Sun JDK version " & minimumJavaVersion & " or greater", 0, "Outdated JDK found"
    Exit Sub
  End If

  'Update the system path if needed
  strPath = AddToPath(strPath, strJavaPath & "\bin")
  If (strPath <> strOrigPath) Then
    WshShell.RegWrite "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\Path", strPath, "REG_EXPAND_SZ"
    If (err) Then
      MsgBox "An error occurred while trying to write to the system registry" & vbCrLf & "You must have Administrator privileges to use this script"
      Exit Sub
    Else
      strResult = "System path was updated to include:" & vbCrLf & strJavaPath
      changesMade = true
    End If
  Else
    strResult = "System path variable was not modified as: " & vbCrLf & strJavaPath & vbCrLf & "was already present"
  End If

  'Add or Correct the JAVA_HOME environment variable if needed
  strJavaHomePath = WshShell.RegRead("HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\JAVA_HOME")
  If (err Or strJavaHomePath <> strJavaPath) Then
    err.clear
    WshShell.RegWrite "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\JAVA_HOME", strJavaPath, "REG_SZ"
    If (err) Then
      MsgBox "An error occurred while trying to write to the system registry" & vbCrLf & "You must have Administrator privileges to use this script"
      Exit Sub
    Else
      WshShell.RegWrite "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\JAVA_HOME", strJavaPath, "REG_SZ"
      strResult = strResult & vbCrLf & vbCrLf & "JAVA_HOME environment variable was added."
      changesMade = true
    End If
  Else
    strResult = strResult & vbCrLf & vbCrLf & "JAVA_HOME environment variable was already present and correct"
  End If

  If (changesMade) Then
    strResult = "Changes Made!  Reboot for them to take effect" & vbCrLf & vbCrLf & strResult
  Else 
    strResult = "No Changes Made - (Already was good to go)" & vbCrLf & vbCrLf & strResult
  End If

  MsgBox strResult, 0, "All Finished!"

End Sub

Call addJavaSDKEnvVars()

