#A simple GUI that displays the result of a running AntSim.

from tkinter import *

import antSim

WINDOW_SIZE  = 600
class AntSimGUI:

    def __init__(self,window,simWorld):
        self.win = window
        self.world = simWorld
        self.canvas = Canvas(window, width=WINDOW_SIZE,height=WINDOW_SIZE,bg="white")
        
        self.canvas.pack()

        self.rbString = StringVar()
        self.rbString.set("randomAH")
        rbFrame = Frame(window)
        rbFrame.pack()
        rb1 = Radiobutton(rbFrame,text="Random",
                          value="randomAH",variable=self.rbString,
                          command=self.reInit)
        rb1.pack(side=LEFT)
        rb2 = Radiobutton(rbFrame, text="Smart",
                          value="smartAH",
                          variable=self.rbString,
                          command=self.reInit)
        rb2.pack(side=LEFT)
        rb3 = Radiobutton(rbFrame, text="Purposeful",
                          value="purposefulAH",variable=self.rbString,
                          command=self.reInit)
        rb3.pack(side=LEFT)
        

        sideFrame = Frame(window)
        sideFrame.pack(side=RIGHT)
        self.winnerEntry = Entry(sideFrame)
        self.winnerEntry.insert(0,"Winner: None")
        self.winnerEntry.pack()
        
        f = Frame(window)
        f.pack(side=BOTTOM)
        self.goButton = Button(f,text="Start!", command=self.doStart)
        self.goButton.pack(side=LEFT)
        self.stopButton = Button(f,text="Stop!", command=self.doStop)
        self.stopButton.pack(side=LEFT)
        self.stepButton = Button(f,text="One Step",command=self.doStep)
        self.stepButton.pack(side=LEFT)
        self.drawFarm()

    def reInit(self):
        #Re-initialize the ant farm!
        self.winnerEntry.delete(0,END)
        self.winnerEntry.insert(0, "Winner: None")
        AntHill = self.rbString.get()
        print("Re Initalizing with ant hill:", AntHill)
        self.world.initialize(AntHill)
        self.drawFarm()
        
    #this button will tell the antSim module to do one step of the
    #simulation and then re-draw the screen!
    def doStep(self):
        self.world.doTurn()
        self.drawFarm()
        if self.world.winner == "Red":
            self.winnerEntry.delete(0,END)
            self.winnerEntry.insert(0, "Winner: Red")
            self.continueRunning = False
        elif self.world.winner == "Green":
            self.winnerEntry.delete(0,END)
            self.winnerEntry.insert(0, "Winner: Green")
            self.continueRunning = False

    def doStart(self):
        self.continueRunning = True
        self.canvas.after(100,self.run)

    def doStop(self):
        self.continueRunning = False

    def run(self):
        self.doStep()
        if self.continueRunning == True:
           self.canvas.after(10, self.run)
        
        #This method will "draw" the antfarm on the canvas...
    def drawFarm(self):
        self.canvas.delete(ALL)  #Delete anything leftover from last time

        #draw the gridlines:
        size = self.world.FARM_SIZE
        if size > WINDOW_SIZE / 2:
            print("ERROR! Sim World is too large!")
            raise Exception("SimWorld too large!")
        step = int( WINDOW_SIZE / size)

        #Draw the grid background
        for i in range(0, WINDOW_SIZE, step):
            self.canvas.create_line(i,0,i,WINDOW_SIZE, fill="gray")
            self.canvas.create_line(0,i,WINDOW_SIZE,i, fill="gray")

        #Draw all the elements of the farm!
        for x in range(0,size):
            for y in range(0,size):
                if self.world.farm[x][y] != "":
                    item = self.world.farm[x][y]
                    if item == "RA":  #Red Ant
                        self.canvas.create_oval((x*step,y*step,x*step+step,y*step+step), fill="red")
                    elif item == "GA": #Green Ant
                        self.canvas.create_oval((x*step,y*step,x*step+step,y*step+step), fill="green")
                    elif item == "RH": #Red anthill
                        self.canvas.create_rectangle((x*step,y*step,x*step+step,y*step+step), fill="darkred")
                    elif item == "GH": #Green anthill
                        self.canvas.create_rectangle((x*step,y*step,x*step+step,y*step+step), fill="darkgreen")
                    elif item == "W": #Wall!
                        self.canvas.create_rectangle((x*step,y*step,x*step+step,y*step+step), fill="gray")
                    elif item == "F": #FOOD!
                        self.canvas.create_oval((x*step,y*step,x*step+step,y*step+step), fill="blue")
             
        
antSim.initialize("randomAH")
win = Tk()
myGui = AntSimGUI(win,antSim)
win.mainloop()
