
import random

#Ant farm simulation Engine 
redHillModule  = None
greenHillModule = None

#globals used to store the game state...
redHill = []    #X,Y, foodEaten
redAnts = []    
greenHill = [] #X, Y, foodEaten
greenAnts = []

winner = None

turnsSinceLastEat = 0   #Watches out for stalled games...

farm = []
FARM_SIZE = 100
TOTAL_FOOD = 1000
WALL_NUM   = 500

def initialize( importName = "randomAH", importName2 = "antHill"):
  global farm
  global redHill
  global greenHill
  global redAnts
  global greenAnts
  global winner
  global redHillModule
  global greenHillModule
  global turnsSinceLastEat
  global greenStudentName
  global greenAHName
  global redStudentName
  global redAHName
  global gaWallDeaths
  global raWallDeaths
  global gaFF
  global raFF
  global greenKamikazi

  gaWallDeaths = 0
  raWallDeaths = 0
  gaFF = 0
  raFF = 0
  greenKamikazi = 0

  
  redHillModule = __import__(importName, globals(), locals(), [], -1)
  print("redHillModule is:", redHillModule)

  greenHillModule = __import__(importName2, globals(), locals(), [], -1)
  print("greenHill is:", greenHillModule)

  #Set up the farm, zero everything out....
  farm = []
  redHill = []    #X,Y, foodEaten
  redAnts = []    
  greenHill = [] #X, Y, foodEaten
  greenAnts = []

  winner = None

  turnsSinceLastEat = 0   #Watches out for stalled games...
  for item in range(FARM_SIZE):
   aList = []
   for item in range(FARM_SIZE):
      aList.append("")
   farm.append(aList) 

  #Put a wall 2 wide around the farm!
  for n in range(FARM_SIZE):
    farm[0][n] = "W"
    farm[1][n] = "W"
    farm[-1][n] = "W"
    farm[-2][n] = "W"
    farm[n][0] = "W"
    farm[n][1] = "W"
    farm[n][-1] = "W"
    farm[n][-2] = "W"


  



 

  #Add random walls (but not too many of them!)
  for i in range(WALL_NUM):
    x = random.randint(3,FARM_SIZE-4)
    y = random.randint(3,FARM_SIZE-4)
    farm[x][y] = "W"

  

  #Initalize both of the players...
  #Set up the two hills  with one ant each at a random location.
  #Red is on the left, green is on the right...
  x = random.randint(4, (FARM_SIZE//3) )
  y = random.randint(4,FARM_SIZE-4)
  redHill = [x,y,1]
  farm[x][y] = "RH"
  #clear the other 8 squares around the hill!
  farm[x-1][y-1] = ""
  farm[x-1][y] = ""
  farm[x-1][y+1] = ""
  farm[x][y-1] = ""
  farm[x][y+1] = ""
  farm[x+1][y-1] = ""
  farm[x+1][y] = ""
  farm[x+1][y+1] = ""

  #Add a single ant!
  redAnts = [ [x+1,y+1] ]
  farm[x+1][y+1] = "RA"

  x = random.randint((FARM_SIZE//3)*2, FARM_SIZE-4)
  y = random.randint(4,FARM_SIZE-4)
  greenHill= [x,y,1]    
  farm[x][y] = "GH"

  #clear the other 8 squares around the hill!
  farm[x-1][y-1] = ""
  farm[x-1][y] = ""
  farm[x-1][y+1] = ""
  farm[x][y-1] = ""
  farm[x][y+1] = ""
  farm[x+1][y-1] = ""
  farm[x+1][y] = ""
  farm[x+1][y+1] = ""
  
  #Add an ant!
  greenAnts = [ [x-1,y-1] ]
  farm[x-1][y-1] = "GA"

  
  #Add random food!
  for i in range(TOTAL_FOOD):
    x = random.randint(0,FARM_SIZE-2)
    y = random.randint(0,FARM_SIZE-2)
    if farm[x][y] == "":
      farm[x][y] = "F"
 

  #Now that we have all that set up, initialize the ant hills!
  retValue = redHillModule.initialize( redHill)
  redStudentName = retValue[0]
  redAHName = retValue[1]
  
  retValue = greenHillModule.initialize(greenHill)
  greenStudentName = retValue[0]
  greenAHName = retValue[1]



   
#Runs a single turn in the simulation engine where both players make
#one move. (single clock tick)
def doTurn(greenFirst = True):
   global winner
   global redHill
   global greenHill
   global turnsSinceLastEat

   if winner != None:
     print ("We have a winner!")
     return
   
   #Used to keep track of how many turns we have done
   #without an ant eating any food.
   global turnsSinceLastEat
   turnsSinceLastEat = turnsSinceLastEat  + 1
   
   if greenFirst:
     ourHill = greenHillModule
     doStep(ourHill,"green")
     checkForWin()
     ourHill = redHillModule
     if winner == None:
        doStep(ourHill,"red")
        checkForWin()
   else:
     ourHill = redHillModule
     doStep(ourHill,"red")
     checkForWin()
     ourHill = greenHillModule
     if winner == None:
        doStep(ourHill,"green")
        checkForWin()


#Check to see if one of the teams has won!
def checkForWin():
  global redHill
  global greenHill
  global winner
  global turnsSinceLastEat

  #If an anthill is gone, the other team wins!
  if redHill[0] == None:
    winner = "Green"
  if greenHill[0] == None:
    winner = "Red"

  #If it has been more than 100 turns since a team ate a food item.
  #Or if all the food is gone....then declare a winner
  if turnsSinceLastEat > 99 or redHill[2] + greenHill[2] == TOTAL_FOOD:
    if redHill[2] > greenHill[2]:
      winner = "Red"
    elif greenHill[2] > redHill[2]:
      winner = "Green"
    elif greenHill[2] == redHill[2]:
      if len(redAnts) > len(greenAnts):
        winner = "Red"
      else:
        winner = "Green"
      
     
def convertSquare(farmSquare, player):
   if player == "red":
      if farmSquare == "RA":
        return "FA"
      if farmSquare == "RH":
        return "FH"
      if farmSquare == "GA":
        return "EA"
      if farmSquare == "GH":
        return "EH"
      return farmSquare
   else: #Player is green:
      if farmSquare == "GA":
        return "FA"
      if farmSquare == "GH":
        return "FH"
      if farmSquare == "RA":
        return "EA"
      if farmSquare == "RH":
        return "EH"
      return farmSquare

#Generates a tuple of values that show what is around each ant!
def generateAntInfo(ant,hillName):
       global farm
       x = ant[0]
       y = ant[1] 
       aList = []
       aList.append( convertSquare( farm[x][y-1],hillName ) )  #Square 1
       aList.append( convertSquare( farm[x+1][y-1],hillName ) )  #Square 2
       aList.append( convertSquare( farm[x+1][y],hillName )  )        #Square 3    
       aList.append( convertSquare( farm[x+1][y+1],hillName )  )         #Square 4    
       aList.append( convertSquare( farm[x][y+1],hillName )   )       #Square 5    
       aList.append( convertSquare( farm[x-1][y+1],hillName )  )        #Square 6    
       aList.append( convertSquare( farm[x-1][y],hillName )   )       #Square 7    
       aList.append( convertSquare( farm[x-1][y-1],hillName ) )         #Square 8    
       aList.append( convertSquare( farm[x][y-2],hillName )  )        #Square 9    
       aList.append( convertSquare( farm[x+1][y-2],hillName ) )         #Square 10    
       aList.append( convertSquare( farm[x+2][y-2],hillName ))          #Square 11 
       aList.append( convertSquare( farm[x+2][y-1],hillName ) )         #Square 12    
       aList.append( convertSquare( farm[x+2][y],hillName )  )        #Square 13    
       aList.append( convertSquare( farm[x+2][y+1],hillName ) )         #Square 14    
       aList.append( convertSquare( farm[x+2][y+2],hillName ) )         #Square 15    
       aList.append( convertSquare( farm[x+1][y+2],hillName ) )         #Square 16    
       aList.append( convertSquare( farm[x][y+2],hillName )   )       #Square 17    
       aList.append( convertSquare( farm[x-1][y+2],hillName ) )         #Square 18    
       aList.append( convertSquare( farm[x-2][y+2],hillName )  )        #Square 19    
       aList.append( convertSquare( farm[x-2][y+1],hillName ) )         #Square 20    
       aList.append( convertSquare( farm[x-2][y],hillName )   )       #Square 21    
       aList.append( convertSquare( farm[x-2][y-1],hillName ))          #Square 22    
       aList.append( convertSquare( farm[x-2][y-2],hillName ) )         #Square 23    
       aList.append( convertSquare( farm[x-1][y-2],hillName ) )         #Square 24
       antView = tuple(aList)
       antTuple = (x,y,antView)
       return antTuple
  
#Runs a single step for a player.
def doStep(hill, hillName):
   global farm
   global redHill
   global redAnts
   global greenHill
   global greenAnts
   #print("Doing a step with:", hill) 

   #first, generate the hill info:
   if hillName == "red":
      hillInfo = tuple(redHill)
   else:
      hillInfo = tuple(greenHill)

   #Then, generate the ant info:
   if hillName == "red":
     ourAnts = redAnts
   else:
     ourAnts = greenAnts
     
   ants = ()
   for item in ourAnts:
       if item[0] != None:  #Don't do it for nonexistant ants!
         ant = generateAntInfo(item, hillName)
         ants = ants + (ant,)
       else:
         print( "why do we have nonexistant ants here?")
         print(ourAnts)
         raise Exception("DEBUGGING!")
   numAnts = len(ants)

   
   #third, call the hill "tick" method and get their moves.
   moves = hill.tick(hillInfo, ants)
   if len(moves) != numAnts:
     raise Exception("InvalidNumberOfMoves")

   for item in moves:
     if type(item) != int:
       raise Exception("InvalidMoveType")

   #print("Moves is:", moves)
   #print("ourAnts:", ourAnts)
   
   #finally, update the farm with the results of their moves.
   for ant,antMove in enumerate(moves):
     if 8 < antMove or antMove < 0:
       raise Exception("InvalidMoveError")
     #Are they doing nothing, or have they died?
     if antMove == 0 or ourAnts[ant][0] == None:
       pass #do nothing!
     else:
        #Otherwise, do the move!
        oldX = ourAnts[ant][0]
        oldY = ourAnts[ant][1]
        if antMove == 1:
          newX = oldX
          newY = oldY-1
        elif antMove == 2:
          newX = oldX + 1
          newY = oldY -1
        elif antMove == 3:
          newX = oldX + 1
          newY = oldY
        elif antMove == 4:
          newX = oldX+1
          newY = oldY+1
        elif antMove == 5:
          newX = oldX
          newY = oldY + 1
        elif antMove == 6:
          newX = oldX -1
          newY = oldY + 1
        elif antMove == 7:
          newX = oldX -1
          newY = oldY
        elif antMove == 8:
          newX = oldX -1
          newY = oldY -1
        processAntMove(oldX,oldY,newX,newY,ant,ourAnts, hillName)

   #Delete any of our ants who have died during their
   #move from the lists...
   i  = 0
   while i < len(redAnts):
     if redAnts[i][0] == None:
       del redAnts[i]
       i = i-1
     i = i+1
   
   i = 0
   while i < len(greenAnts):
     if greenAnts[i][0] == None:
       del greenAnts[i]
       i = i-1
     i = i + 1
     
   
        
   
     

def processAntMove(oldX,oldY,newX,newY, antIndex, antList, hillName):
  global farm
  global redHill
  global greenHill
  global turnsSinceLastEat
  global gaWallDeaths
  global raWallDeaths
  global gaFF
  global raFF
  global greenKamikazi

  #print("old/new:(",oldX,",",oldY,")(",newX,",",newY,") ant indx:",antIndex)
  #If they are moving into an empty area, no big deal!
  
  if farm[newX][newY] == "":
    #print("Empty space!")
    farm[newX][newY] = farm[oldX][oldY]
    farm[oldX][oldY] = ""
    antList[antIndex][0] = newX
    antList[antIndex][1] = newY
    return

  #If they walk into a wall, they die!
  if farm[newX][newY] == "W":
    if hillName == "red":
       #print("A red ant walked into a wall!")
       raWallDeath = raWallDeaths + 1
    else:
      print("A green ant walked into a wall!")
      gaWallDeaths = gaWallDeaths + 1
    #print("Wall!")
    killAnt(oldX,oldY,antList)
    
    return

  #If they walk into food, they eat it and spawn a new ant!
  if farm[newX][newY] == "F":
    #print("Food!")
    farm[newX][newY] = farm[oldX][oldY]
    farm[oldX][oldY] = ""
    antList[antIndex][0] = newX
    antList[antIndex][1] = newY
    spawnAnt(hillName)
    #Increment our hill's score!
    turnsSinceLastEat = 0
    if hillName == "red":
      redHill[2] = redHill[2] + 1
    else:
      greenHill[2] = greenHill[2] + 1
    return

  #If they walk into another ant, both ants die!
  if farm[newX][newY] == "RA":
     global redAnts
     if hillName == "red":
       #print("A red ant killed another red ant!")
       raFF = raFF+1
     #print("Ant!")
     killAnt(newX,newY,redAnts)
     killAnt(oldX,oldY,antList)
     return
    
  if farm[newX][newY] == "GA":
    global greenAnts
    if hillName == "green":
        #print("A green Ant killed another green ant!")
        gaFF = gaFF+1
    #print("Ant!")
    killAnt(newX,newY,greenAnts)
    killAnt(oldX,oldY,antList)
    return

  #If they hit an anthill (even their own!) they kill it!
  if farm[newX][newY] == "RH":
    print("Red Anthill Killed by an Ant!")
    redHill[0]=None
    redHill[1]=None
    farm[newX][newY] = farm[oldX][oldY]
    farm[oldX][oldY] = ""
    antList[antIndex][0] = newX
    antList[antIndex][1] = newY
    return

  if farm[newX][newY] == "GH":
    print("Green Anthill Killed by an Ant!")
    if hillName == "green":greenKamikazi += 1      
    greenHill[0] = None
    greenHill[1] = None
    farm[newX][newY] = farm[oldX][oldY]
    farm[oldX][oldY] = ""
    antList[antIndex][0] = newX
    antList[antIndex][1] = newY
    return

  #If they get to here, something is wrong!
  print("An ant did something that I don't understand, fix this!")
  

#Kill any ants in the list at this x,y location, also update the farm!
def killAnt(X,Y, antList):
  global farm
  farm[X][Y] = ""
  for item in antList:
    if item[0] == X and item[1] == Y:
      item[0]=None
      item[1]=None
  
#Create a new ant near the appropriate hill (if possible!)
def spawnAnt(hillName):
  global redHill
  global redAnts
  global greenHill
  global greenAnts
  
  #todo:
  if hillName == "red":
    ourHill = redHill
    ourAnts = redAnts
    antString = "RA"
  else:
    ourHill = greenHill
    ourAnts = greenAnts
    antString = "GA"
    
  X = ourHill[0]
  Y = ourHill[1]

  #Try to drop the ant in an empty square near the ant hill.
  #If no empty spot is found, we do not drop the ant!
  for spot in [ (0,-1), (-1,1),(1,0), (1,1), (0,1), (1,-1), (-1,0),(-1,-1)]:
    antX = X+spot[0]
    antY = Y+spot[1]
    if farm[antX][antY] == "":
       #drop ant.
       farm[antX][antY] = antString
       ourAnts.append( [antX,antY] )
       return

  #We didn't find a spot for the ant due to overcrowding! Sucks for them!
  return
       
       
    
    
   

#If this code is ran directly, run a single game turn for testing!
if __name__ == "__main__":
  initialize()
  doTurn()
                     
