/**
 * Sample code for Assignment #4
 *
 * Author: David Nguyen (dnguyen@cc.gatech.edu)
 */

import java.awt.*;
import java.awt.event.*;

import com.ibm.bridge2java.*;   // required to access COM stuff...
import Phidgets.*;              // the generated java wrappers for the phidgets
import java.net.*;              // needed for the JIntegra stuff
import java.io.*;               // this too


public class Sample implements _IPhidgetManagerEvents, AdjustmentListener
{
    private Frame frame;
    private Scrollbar scrollbar;
    private TextField systemMsg;                         // at/detach messages go here...
    private TextField phidgetMsg;                        // info about the individual phidget goes here
    
    private PhidgetManager manager;                      // to get events from at/detaching phidgets
    
    private PhidgetInterfaceKit kit;
    private PhidgetServo servo;
    
    final static private String SERVO = "phidgetservo";        // values returned by the COM object
    final static private String KIT   = "phidgetinterfacekit";
    
    public Sample() {
        kit = null;
        servo = null;
        
        //
        // The important Phidgets initialization
        //
        
        // init com stuff
        OleEnvironment.Initialize() ;
        
        manager = new PhidgetManager();
        manager.add_IPhidgetManagerEventsListener(this);
        
        //
        // normal AWT stuff...
        // used AWT because J++ doesn't have built-in support for Swing
        //
        frame = new Frame("Phidgets Sample Code");
        scrollbar = new Scrollbar(Scrollbar.HORIZONTAL, 0, 5, 0, 1000);
        systemMsg = new TextField(40);
        phidgetMsg = new TextField(40);
        
        scrollbar.addAdjustmentListener(this);
        
        frame.setLayout(new BorderLayout());
        frame.add(scrollbar, BorderLayout.NORTH);
        frame.add(systemMsg, BorderLayout.CENTER);
        frame.add(phidgetMsg, BorderLayout.SOUTH);
        
        frame.addWindowListener(new MyWindowAdapter());
        
        frame.pack();
        frame.show();
    }
    
    
    //
    // _IPhidgetManagerEvents interface
    //
    public void OnAttach(_IPhidgetManagerEvents_OnAttachEvent e) {
        systemMsg.setText("Attached! Type: " + e.get_PHIDGET().get_DeviceType());
        
        try {
            if (e.get_PHIDGET().get_DeviceType().equalsIgnoreCase(KIT)) {
                phidgetMsg.setText("attaching kit");
                kit = new PhidgetInterfaceKit(e.get_PHIDGET().IDispatch);
                kit.add_IPhidgetInterfaceKitEventsListener(new _IPhidgetInterfaceKitEvents() {
                            public void OnDetach(_IPhidgetInterfaceKitEvents_OnDetachEvent ke) {
                                phidgetMsg.setText("Kit detached");
                            }
                            
                            public void OnError(_IPhidgetInterfaceKitEvents_OnErrorEvent ke) {
                                phidgetMsg.setText("Kit error: " + ke.get_Description());
                            }
                            
                            public void OnInputChange(_IPhidgetInterfaceKitEvents_OnInputChangeEvent ke) {
                                phidgetMsg.setText("Input " + ke.get_Index() + " Changed: " + ke.get_NewState());
                            }
                            
                            public void OnOutputChange(_IPhidgetInterfaceKitEvents_OnOutputChangeEvent ke) {
                                phidgetMsg.setText("Output " + ke.get_Index() + " Changed: " + ke.get_NewState());
                            }
                            
                            public void OnSensorChange(_IPhidgetInterfaceKitEvents_OnSensorChangeEvent ke) {
                                int index = ke.get_Index();
                                int sensorValue = ke.get_SensorValue();
                                
                                phidgetMsg.setText("Sensor " + index + " Changed: " + sensorValue + ", Raw value: " + kit.get_SensorRawValue(index));
                                scrollbar.setValue(sensorValue);
                                
                                //
                                // silliness
                                //
                                if (servo != null) {
                                    // set the position of the servo
                                    // normalize position to be between 0 and 180
                                    servo.set_MotorPosition(servo.get_NumMotors(), (int)(sensorValue/1000.0*180));
                                }
                                
                                // attach LEDs and see the fun!
                                if (sensorValue > 100) {
                                    kit.set_OutputState(1, true);
                                } else {
                                    kit.set_OutputState(1, false);
                                }
                                
                                if (sensorValue > 200) {
                                    kit.set_OutputState(2, true);
                                } else {
                                    kit.set_OutputState(2, false);
                                }
                                
                                if (sensorValue > 300) {
                                    kit.set_OutputState(3, true);
                                } else {
                                    kit.set_OutputState(3, false);
                                }
                                
                                if (sensorValue > 400) {
                                    kit.set_OutputState(4, true);
                                } else {
                                    kit.set_OutputState(4, false);
                                }
                                if (sensorValue > 500) {
                                    kit.set_OutputState(5, true);
                                } else {
                                    kit.set_OutputState(5, false);
                                }
                                if (sensorValue > 600) {
                                    kit.set_OutputState(6, true);
                                } else {
                                    kit.set_OutputState(6, false);
                                }
                                if (sensorValue > 700) {
                                    kit.set_OutputState(7, true);
                                } else {
                                    kit.set_OutputState(7, false);
                                }
                                if (sensorValue > 800) {
                                    kit.set_OutputState(8, true);
                                } else {
                                    kit.set_OutputState(8, false);
                                }
                            }
                            
                        });
            }
            
            if (e.get_PHIDGET().get_DeviceType().equalsIgnoreCase(SERVO)) {
                phidgetMsg.setText("attaching servo");
                servo = new PhidgetServo(e.get_PHIDGET().IDispatch);
            }
        }
        catch (Exception ex) {
            System.err.println("YIKES!! " + ex);
            ex.printStackTrace();
        }
    }
    
    public void OnDetach(_IPhidgetManagerEvents_OnDetachEvent e) {
        systemMsg.setText("Detached! Type: " + e.get_PHIDGET().get_DeviceType());
        
        if (e.get_PHIDGET().get_DeviceType().equalsIgnoreCase(KIT)) {
            phidgetMsg.setText("Detaching interface kit");
            kit = null;
        }
        
        if (e.get_PHIDGET().get_DeviceType().equalsIgnoreCase(SERVO)) {
            phidgetMsg.setText("Detaching servo");
            servo = null;
        }
    }
    
    public void OnError(_IPhidgetManagerEvents_OnErrorEvent e) {
        systemMsg.setText("Error! " + e.get_Description() + ". Count: " + manager.get_Count());
        phidgetMsg.setText("");
    }
    
    
    
    
    //
    // AdjustmentListener interface
    //
    public void adjustmentValueChanged(AdjustmentEvent e) {
        phidgetMsg.setText("Scrollbar value: " + e.getValue());
        
        if (servo != null) {
            // set the position of the servo
            // normalize position to be between 0 and 180
            servo.set_MotorPosition(servo.get_NumMotors(), (int)(e.getValue()/1000.0*180));
        }
        
        if (kit != null) {
            // turn on output(LEDs are a good way to see it)
            if (e.getValue() > 100) {
                kit.set_OutputState(1, true);
            } else {
                kit.set_OutputState(1, false);
            }
            
            if (e.getValue() > 200) {
                kit.set_OutputState(2, true);
            } else {
                kit.set_OutputState(2, false);
            }
            
            if (e.getValue() > 300) {
                kit.set_OutputState(3, true);
            } else {
                kit.set_OutputState(3, false);
            }
            
            if (e.getValue() > 400) {
                kit.set_OutputState(4, true);
            } else {
                kit.set_OutputState(4, false);
            }
            if (e.getValue() > 500) {
                kit.set_OutputState(5, true);
            } else {
                kit.set_OutputState(5, false);
            }
            if (e.getValue() > 600) {
                kit.set_OutputState(6, true);
            } else {
                kit.set_OutputState(6, false);
            }
            if (e.getValue() > 700) {
                kit.set_OutputState(7, true);
            } else {
                kit.set_OutputState(7, false);
            }
            if (e.getValue() > 800) {
                kit.set_OutputState(8, true);
            } else {
                kit.set_OutputState(8, false);
            }
        }
    }
    
    
    static public void main(String args[]) {
        new Sample();
    }
}

class MyWindowAdapter extends WindowAdapter {
    public void windowClosing(WindowEvent e) {
        // cleanup for Bridge2Java
        OleEnvironment.UnInitialize();
        System.exit(1);
    }
}
