/**
 * Test.java
 *
 * Implements a simple JFC frame. To show this frame use:
 *
 * Test frame = new Test();
 * frame.pack();
 * frame.show();
 *
 *
 * @author Created by Omnicore CodeGuide
 */


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Test extends JFrame
{
	/**
	 * Initializes the frame.
	 */
	public Test()
	{
		super("Test");
		
		// Add menu.
		
		ActionListener exitMenuItemListener = new ActionListener()
		{
			/**
			 * Invoked when an action occurs.
			 */
			public void actionPerformed(ActionEvent e)
			{
				Test.this.close();
			}
		};
		JMenuItem exitMenuItem = new JMenuItem("Exit");
		exitMenuItem.addActionListener(exitMenuItemListener);
		JMenu fileMenu = new JMenu("File");
		fileMenu.add(exitMenuItem);
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(fileMenu);
		setJMenuBar(menuBar);
		
		// Add window listener.
		
		this.addWindowListener
		(
			new WindowAdapter()
			{
				/**
				 * Called when window close button was pressed.
				 */
				public void windowClosing(WindowEvent e)
				{
					Test.this.close();
				}
			}
		);
		
		// TODO: Create your components...
		JLabel label = new JLabel("go away");
		JDualScrollBar ds = new JDualScrollBar();

		// TODO: Add your components...
		
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(label, BorderLayout.CENTER);
		getContentPane().add(ds, BorderLayout.EAST);
		
	}
	
	/**
	 * Shows the frame.
	 */
	public void show()
	{
		// You can also use: Dimension size = new Dimension(300,200);
		Dimension size = getPreferredSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds
		(
			(screenSize.width - size.width) / 2,
			(screenSize.height - size.height) / 2,
			size.width,
			size.height
		);
		
		super.show();
	}
	
	/**
	 * Closes the frame.
	 */
	private void close()
	{
		setVisible(false);
		
		System.exit(0); // Delete this line if necessary.
	}
	
	public static void main (String[] args) {
		Test test = new Test();
		test.pack();
		test.show();
	}
}

